/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import io.github.frqnny.mostructures.structure.ConfigMS;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6626;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class StructurePoolBasedGenerator {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<class_6622<ConfigMS>> generate(class_6834.class_6835<ConfigMS> context, PieceFactory pieceFactory, class_2338 pos, boolean bl, boolean bl2) {
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        class_5455 dynamicRegistryManager = context.comp_314();
        ConfigMS ConfigMS2 = (ConfigMS)context.comp_310();
        class_2794 chunkGenerator = context.comp_306();
        class_3485 structureManager = context.comp_313();
        class_5539 heightLimitView = context.comp_311();
        Predicate predicate = context.comp_312();
        class_3195.method_28664();
        class_2378 registry = dynamicRegistryManager.method_30530(class_2378.field_25917);
        class_2470 blockRotation = class_2470.method_16548((Random)chunkRandom);
        class_3785 structurePool = (class_3785)ConfigMS2.method_27223().comp_349();
        class_3784 structurePoolElement = structurePool.method_16631((Random)chunkRandom);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        class_3790 poolStructurePiece = pieceFactory.create(structureManager, structurePoolElement, pos, structurePoolElement.method_19308(), blockRotation, structurePoolElement.method_16628(structureManager, pos, blockRotation));
        class_3341 blockBox = poolStructurePiece.method_14935();
        int i = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int j = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int k = bl2 ? pos.method_10264() + chunkGenerator.method_20402(i, j, class_2902.class_2903.field_13194, heightLimitView) : pos.method_10264();
        if (!predicate.test(chunkGenerator.method_16359(class_5742.method_33100((int)i), class_5742.method_33100((int)k), class_5742.method_33100((int)j)))) {
            return Optional.empty();
        }
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(0, k - l, 0);
        return Optional.of((structurePiecesCollector, contextx) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (ConfigMS2.method_27222() > 0) {
                class_238 box = new class_238((double)(i - 80), (double)(k - 80), (double)(j - 80), (double)(i + 80 + 1), (double)(k + 80 + 1), (double)(j + 80 + 1));
                StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator((class_2378<class_3785>)registry, ConfigMS2.method_27222(), pieceFactory, chunkGenerator, structureManager, list, (Random)chunkRandom);
                structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, (MutableObject<class_265>)new MutableObject((Object)class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886)), 0));
                while (!structurePoolGenerator.structurePieces.isEmpty()) {
                    ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
                    structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, bl, heightLimitView);
                }
                Objects.requireNonNull(structurePiecesCollector);
                list.forEach(arg_0 -> ((class_6626)structurePiecesCollector).method_35462(arg_0));
            }
        });
    }

    public static void generate(class_5455 registryManager, class_3790 piece, int maxDepth, PieceFactory pieceFactory, class_2794 chunkGenerator, class_3485 structureManager, List<? super class_3790> results, Random random, class_5539 world) {
        class_2378 registry = registryManager.method_30530(class_2378.field_25917);
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator((class_2378<class_3785>)registry, maxDepth, pieceFactory, chunkGenerator, structureManager, results, random);
        structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(piece, (MutableObject<class_265>)new MutableObject((Object)class_259.field_17669), 0));
        while (!structurePoolGenerator.structurePieces.isEmpty()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, false, world);
        }
    }

    public static interface PieceFactory {
        public class_3790 create(class_3485 var1, class_3784 var2, class_2338 var3, int var4, class_2470 var5, class_3341 var6);
    }

    static final class StructurePoolGenerator {
        final Deque<ShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();
        private final class_2378<class_3785> registry;
        private final int maxSize;
        private final PieceFactory pieceFactory;
        private final class_2794 chunkGenerator;
        private final class_3485 structureManager;
        private final List<? super class_3790> children;
        private final Random random;

        StructurePoolGenerator(class_2378<class_3785> registry, int maxSize, PieceFactory pieceFactory, class_2794 chunkGenerator, class_3485 structureManager, List<? super class_3790> children, Random random) {
            this.registry = registry;
            this.maxSize = maxSize;
            this.pieceFactory = pieceFactory;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.children = children;
            this.random = random;
        }

        void generatePiece(class_3790 piece, MutableObject<class_265> pieceShape, int minY, boolean modifyBoundingBox, class_5539 world) {
            class_3784 structurePoolElement = piece.method_16644();
            class_2338 blockPos = piece.method_16648();
            class_2470 blockRotation = piece.method_16888();
            class_3785.class_3786 projection = structurePoolElement.method_16624();
            boolean bl = projection == class_3785.class_3786.field_16687;
            MutableObject<class_265> mutableObject = new MutableObject<class_265>();
            class_3341 blockBox = piece.method_14935();
            int i = blockBox.method_35416();
            block0: for (class_3499.class_3501 structureBlockInfo : structurePoolElement.method_16627(this.structureManager, blockPos, blockRotation, this.random)) {
                class_2350 direction = class_3748.method_26378((class_2680)structureBlockInfo.field_15596);
                class_2338 blockPos2 = structureBlockInfo.field_15597;
                class_2338 blockPos3 = blockPos2.method_10093(direction);
                int j = blockPos2.method_10264() - i;
                int k = -1;
                class_2960 identifier = new class_2960(structureBlockInfo.field_15595.method_10558("pool"));
                Optional optional = this.registry.method_17966(identifier);
                if (optional.isPresent() && (((class_3785)optional.get()).method_16632() != 0 || Objects.equals(identifier, class_5468.field_26254.method_29177()))) {
                    class_2960 identifier2 = ((class_3785)optional.get()).method_16634();
                    Optional optional2 = this.registry.method_17966(identifier2);
                    if (optional2.isPresent() && (((class_3785)optional2.get()).method_16632() != 0 || Objects.equals(identifier2, class_5468.field_26254.method_29177()))) {
                        class_3784 structurePoolElement2;
                        MutableObject<class_265> mutableObject2;
                        boolean bl2 = blockBox.method_14662((class_2382)blockPos3);
                        if (bl2) {
                            mutableObject2 = mutableObject;
                            if (mutableObject.getValue() == null) {
                                mutableObject.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)));
                            }
                        } else {
                            mutableObject2 = pieceShape;
                        }
                        ArrayList list = Lists.newArrayList();
                        if (minY != this.maxSize) {
                            list.addAll(((class_3785)optional.get()).method_16633(this.random));
                        }
                        list.addAll(((class_3785)optional2.get()).method_16633(this.random));
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && (structurePoolElement2 = (class_3784)iterator.next()) != class_3777.field_16663) {
                            for (class_2470 blockRotation2 : class_2470.method_16547((Random)this.random)) {
                                List list2 = structurePoolElement2.method_16627(this.structureManager, class_2338.field_10980, blockRotation2, this.random);
                                class_3341 blockBox2 = structurePoolElement2.method_16628(this.structureManager, class_2338.field_10980, blockRotation2);
                                int l = modifyBoundingBox && blockBox2.method_14660() <= 16 ? list2.stream().mapToInt(structureBlockInfox -> {
                                    if (!blockBox2.method_14662((class_2382)structureBlockInfox.field_15597.method_10093(class_3748.method_26378((class_2680)structureBlockInfox.field_15596)))) {
                                        return 0;
                                    }
                                    class_2960 identifiera = new class_2960(structureBlockInfox.field_15595.method_10558("pool"));
                                    Optional optional3 = this.registry.method_17966(identifiera);
                                    Optional<Integer> optional4 = optional3.flatMap(pool -> this.registry.method_17966(pool.method_16634()));
                                    int i2 = optional3.map(pool -> pool.method_19309(this.structureManager)).orElse(0);
                                    int j2 = optional4.map(pool -> pool.method_19309(this.structureManager)).orElse(0);
                                    return Math.max(i2, j2);
                                }).max().orElse(0) : 0;
                                for (class_3499.class_3501 structureBlockInfo2 : list2) {
                                    int t;
                                    int r;
                                    int p;
                                    if (!class_3748.method_16546((class_3499.class_3501)structureBlockInfo, (class_3499.class_3501)structureBlockInfo2)) continue;
                                    class_2338 blockPos4 = structureBlockInfo2.field_15597;
                                    class_2338 blockPos5 = blockPos3.method_10059((class_2382)blockPos4);
                                    class_3341 blockBox3 = structurePoolElement2.method_16628(this.structureManager, blockPos5, blockRotation2);
                                    int m = blockBox3.method_35416();
                                    class_3785.class_3786 projection2 = structurePoolElement2.method_16624();
                                    boolean bl3 = projection2 == class_3785.class_3786.field_16687;
                                    int n = blockPos4.method_10264();
                                    int o = j - n + class_3748.method_26378((class_2680)structureBlockInfo.field_15596).method_10164();
                                    if (bl && bl3) {
                                        p = i + o;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world);
                                        }
                                        p = k - n;
                                    }
                                    int q = p - m;
                                    class_3341 blockBox4 = blockBox3.method_19311(0, q, 0);
                                    class_2338 blockPos6 = blockPos5.method_10069(0, q, 0);
                                    if (l > 0) {
                                        r = Math.max(l + 1, blockBox4.method_35419() - blockBox4.method_35416());
                                        blockBox4.method_34389(new class_2338(blockBox4.method_35415(), blockBox4.method_35416() + r, blockBox4.method_35417()));
                                    }
                                    if (class_259.method_1074((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                                    mutableObject2.setValue((Object)class_259.method_1082((class_265)((class_265)mutableObject2.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox4)), (class_247)class_247.field_16886));
                                    r = piece.method_16646();
                                    int s = bl3 ? r - o : structurePoolElement2.method_19308();
                                    class_3790 poolStructurePiece = this.pieceFactory.create(this.structureManager, structurePoolElement2, blockPos6, s, blockRotation2, blockBox4);
                                    if (bl) {
                                        t = i + j;
                                    } else if (bl3) {
                                        t = p + n;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, world);
                                        }
                                        t = k + o / 2;
                                    }
                                    piece.method_16647(new class_3780(blockPos3.method_10263(), t - j + r, blockPos3.method_10260(), o, projection2));
                                    poolStructurePiece.method_16647(new class_3780(blockPos2.method_10263(), t - n + s, blockPos2.method_10260(), -o, projection));
                                    this.children.add((class_3790)poolStructurePiece);
                                    if (minY + 1 > this.maxSize) continue block0;
                                    this.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, minY + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)identifier2);
                    continue;
                }
                LOGGER.warn("Empty or non-existent pool: {}", (Object)identifier);
            }
        }
    }

    private static final class ShapedPoolStructurePiece {
        final class_3790 piece;
        final MutableObject<class_265> pieceShape;
        final int currentSize;

        ShapedPoolStructurePiece(class_3790 piece, MutableObject<class_265> pieceShape, int currentSize) {
            this.piece = piece;
            this.pieceShape = pieceShape;
            this.currentSize = currentSize;
        }
    }
}

